/** @file   proctorai.h
 * @brief   Declarations of ProctorAI - class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef H_WWW_PROCTORAI_H
#define H_WWW_PROCTORAI_H

#include "aicontroller.h"

namespace WeWantWar {


/**
 * @par Behaviour of the Proctor Alien
 * Proctor Alien is some kind of alien "police". When he has not seen the
 * player he just stands still. When he gets the player in sigth (or when
 * player shoots him) he starts moving randomly. If he can see the player,
 * he start moving toward the player and shoot him when within the shooting
 * range.
 * @par
 * After he has shot he moves randomly during the time it takes to reload
 * the shotgun and then he shoots player again.
 *
 * @brief       The logic that controls the ProctorAlien.
 * @author      Tomi Lamminsaari
 */
class ProctorAI : public AIController
{
public:

  ///
  /// Static members
  /// ==============
  
  /** The distance from target when we shoot */
  static const float SHOOT_DISTANCE;
  

  ///
  /// Constructor, destructor
  /// =======================
  
  /** Constructor.
   * @param     pAlien            Pointer to alien we're controlling.
   */
  ProctorAI( GameObject* pAlien );
  
  /** Constructor.
   */
  virtual ~ProctorAI();
  
  
  ///
  /// Methods
  /// =======
  
  /** Updates the controlling commands.
   */
  virtual void updateAI( bool seeTarget, float dist );
  
  /** Sets the alerted mode on/off
   * @param     alerted           New alerted-mode flag.
   */
  void setAlerted( bool alerted );
  
  
protected:
  
  ///
  /// Members
  /// =======
  
  /** Tells if we're in alerted mode. */
  bool      m_alerted;
  
};

};  // end of namespace

#endif // PROCTORAI_H

